
class MembresB{//d\u00e9fini sur un carr\u00e9 de 300/300
  int depend;//numero du monstre dont il d\u00e9pend
  float x;// x par rapport \u00e0 l'attache
  float y;// y par rapport \u00e0 l'attache
  int att;// index du corps d'attache
  float attX;
  float attY;
  float attR;
  public void setAttache() {
    this.attX=monstre[depend].corps[att].xR;
    this.attY=monstre[depend].corps[att].yR;
    this.attR=monstre[depend].corps[att].r;
  }
  public void relie(float xR,float yR,float attX,float attY,float r,float attR) {
    float inclin=atan2(yR-attY,xR-attX);
    beginShape();
    vertex(xR+(cos(inclin+HALF_PI)*r),yR+(sin(inclin+HALF_PI)*r));
    vertex(xR+(cos(inclin-HALF_PI)*r),yR+(sin(inclin-HALF_PI)*r));
    vertex(attX+(cos(inclin-HALF_PI)*attR),attY+(sin(inclin-HALF_PI)*attR));
    vertex(attX+(cos(inclin+HALF_PI)*attR),attY+(sin(inclin+HALF_PI)*attR));
    vertex(xR+(cos(inclin+HALF_PI)*r),yR+(sin(inclin+HALF_PI)*r));
    endShape();
  }
}

class Corps extends MembresB{
  float r;//rayon du cercle
  float xR;//x r\u00e9el
  float yR;//y r\u00e9el

  float bougeT;
  float bougeF;  //force
  float bougeTPlus;  //increment de bougeT
  Corps(int depend, int att, float x, float y, float r) {
    this.depend=depend;
    this.att=att;
    this.x=x;
    this.y=y;
    this.r=r;
    bougeF=1;//force
    bougeTPlus=0.1;
  }
  public void initMvts(int nb) {
    bougeF=1;//force
    bougeTPlus=0.1;
    for (int i=0;i<monstre[depend].nbBecs;i++) {
      if (monstre[depend].bec[i].att==nb) {
        bougeF*=0.9;
        bougeTPlus*=0.8;
      }
    }
    for (int i=0;i<monstre[depend].nbYeux;i++) {
      if (monstre[depend].oeil[i].att==nb) {
        bougeF*=0.9;
        bougeTPlus*=0.9;        
      }
    }  
    for (int i=0;i<monstre[depend].nbCorps;i++) {
      if (monstre[depend].corps[i].att==nb) {
        bougeF*=0.8;
        bougeTPlus*=0.8;        
      }
    }
    for (int i=0;i<monstre[depend].nbJambes;i++) {
      if (monstre[depend].jambe[i].att==nb) {
        bougeF*=0.5;
        bougeTPlus*=0.5;
        int tmpAtt=att;
        for (int i2=0;i2<nbMembresMax;i2++) {
          monstre[depend].corps[tmpAtt].bougeF*=0.5;
          monstre[depend].corps[tmpAtt].bougeTPlus*=0.5;     
          tmpAtt=monstre[depend].corps[tmpAtt].att;
        }
      }
    }
  }
  public void agit() {
    bougeT=(bougeT+bougeTPlus)%TWO_PI;
  }
  public void dessine() {
    float actX=cos(0);
    float actY=sin(0);
    if (phase==3) {
      if (monstre[depend].samuse && monstre[depend].action==0) {
        float longu=longueur(x,y,0,0);
        float angl=atan2(y,x);
        xR=attX+longu*cos(angl+bougeF*cos(bougeT));
        yR=min(attY+longu*sin(angl+bougeF*cos(bougeT)),mCY/2-r);
      }
      else{
        xR=(xR+attX+x)/2;
        yR=(yR+attY+y)/2;        
      }
    }
    else {
      xR=attX+x;
      yR=attY+y;
    }
    ellipse(xR,yR,r*2,r*2);
    relie(xR,yR,attX,attY,r,attR);
  }
}

class Jambes extends MembresB{
  float xRT;//x r\u00e9el th\u00e9orique (sans le d\u00e9placement)
  float yRT;//y r\u00e9el th\u00e9orique (sans le d\u00e9placement)
  float xR;//x r\u00e9el
  float yR;//y r\u00e9el
  float gX;//genouX
  float gY;//genouY
  float gXR;//genouX r\u00e9el
  float gYR;//genouY r\u00e9el
  float lJ;//longueur jambe (partie du bas)
  float radJam;//hauteur des jambes lors de la marche
  float angJam;//d\u00e9calage de phase entre les jambes
  float xPrec;//la position en x du pied le plus bas pr\u00e9c\u00e9dent
  float yEntree;

  Jambes(int depend, int att, float x,float y) {
    this.yEntree=y;
    this.depend=depend;
    this.att=att;
    this.y=solModel-monstre[depend].corps[att].yR;
    this.x=x;
    this.gX=x;
    this.gY=y;
    this.lJ=solModel-gY-monstre[depend].corps[att].yR;
  }
  public void agit(int i) {
    xPrec=xR;
    radJam=(sizModel/3)/monstre[depend].nbJambes;
    angJam=(TWO_PI/monstre[depend].nbJambes);
    xRT=attX+x;
    yRT=attY+y;
    float t2Spe=monstre[depend].t2*monstre[depend].nbJambes;
    if (monstre[depend].nbJambes==1) {//exception si juste une jambe
      radJam=sizModel/9;
      t2Spe=monstre[depend].t2*3;
    }
    xR=xRT+cos(t2Spe+i*angJam)*radJam*monstre[depend].actEner;
    yR=yRT+sin(t2Spe+i*angJam)*radJam*monstre[depend].actEner;
    gXR=attX+gX;
    gYR=yR-lJ;
    if (lJ<sizModel/10) {
      lJ+=sizModel/1000;
    }
  }
  public void dessine() {
    relie(gXR,gYR,attX,attY,attR/2,attR);
    ellipse(gXR,gYR,attR,attR);
    relie(xR,yR,gXR,gYR,0,attR/2);
  }
}

class Becs extends MembresB{
  float a;//angle
  float l;//longueur
  float o;//niveau d'ouverture (radians)
  float xR;//x r\u00e9el
  float yR;//y r\u00e9el
  float[] ptx=new float[4];
  float[] pty=new float[4];
  Becs(int depend, int att, float x, float y) {
    this.depend=depend;    
    this.att=att;
    this.x=x;
    this.y=y;
    this.a=atan2(y,x);
    this.l=sqrt(sq(x)+sq(y));
  }
  public void agit(int i) {
    o=(o+(sin(t1+i*(TWO_PI/monstre[depend].nbBecs))+1)/3*monstre[depend].chante)/2;
  }
  public void dessine() {
    ptx[0]=attX+cos(a-HALF_PI)*attR;
    pty[0]=attY+sin(a-HALF_PI)*attR;
    ptx[1]=attX+cos(a+HALF_PI)*attR;
    pty[1]=attY+sin(a+HALF_PI)*attR;
    ptx[2]=attX+cos(a+o)*l;
    pty[2]=attY+sin(a+o)*l;
    ptx[3]=attX+cos(a-o)*l;
    pty[3]=attY+sin(a-o)*l;
    xR=(ptx[2]+ptx[3])/2;//indicatif
    yR=(pty[2]+pty[3])/2;//indicatif
    triangle(ptx[0],pty[0],ptx[1],pty[1],ptx[2],pty[2]);
    triangle(ptx[0],pty[0],ptx[1],pty[1],ptx[3],pty[3]);
  }
}

class Yeux extends MembresB{
  float r;//rayon du cercle
  float xR;//x r\u00e9el
  float yR;//y r\u00e9el
  float regA;
  Yeux(int depend, int att, float x, float y, float r) {
    this.depend=depend;    
    this.att=att;
    this.x=x;
    this.y=y;
    this.r=r;
  }
  public void agit() {
    regA=atan2(monstre[depend].regardeY-yR,monstre[depend].regardeX-xR);
  }
  public void dessine() {
    xR=attX+x;
    yR=attY+y;
    ellipse(xR,yR,r*2,r*2);
    relie(xR,yR,attX,attY,r,attR);
  }
  public void dessinePupille() {
    ellipse(xR+cos(regA)*r/3,yR+sin(regA)*r/3,r,r);
  }
}

class MembresC {
  int depend;//monstre dont il depend
  int att;//vertebre \u00e0 laquelle il est rattach\u00e9
  float l;//longueur
  float corr;

  float vraiX1;
  float vraiX2;
  float vraiY1;
  float vraiY2;
  float angle;
  float bXR;
  float bYR;
  float gB1;//grosseur de la base
  float gB2;//grosseur de la base 
  float xR;
  float yR;

  public void defVraisD() {
    vraiX1=monstre[depend].xRVert2[max(att-1,0)];
    vraiX2=monstre[depend].xRVert2[min(att+1,nbVertebres-1)];
    vraiY1=monstre[depend].yRVert2[max(att-1,0)];
    vraiY2=monstre[depend].yRVert2[min(att+1,nbVertebres-1)];
    angle=atan2(vraiY2-vraiY1,vraiX2-vraiX1)-corr;
    bXR=monstre[depend].xRVert2[att];
    bYR=monstre[depend].yRVert2[att];
    gB1=longueur(vraiX1,vraiY1,bXR,bYR);//grosseur de la base
    gB2=longueur(bXR,bYR,vraiX2,vraiY2);//grosseur de la base
    xR=bXR+l*cos(angle+HALF_PI);
    yR=bYR+l*sin(angle+HALF_PI);   
  }
  public void defVraisG() {
    vraiX1=monstre[depend].xRVert[max(att-1,0)];
    vraiX2=monstre[depend].xRVert[min(att+1,nbVertebres-1)];
    vraiY1=monstre[depend].yRVert[max(att-1,0)];
    vraiY2=monstre[depend].yRVert[min(att+1,nbVertebres-1)];
    angle=atan2(vraiY2-vraiY1,vraiX2-vraiX1)+corr;
    bXR=monstre[depend].xRVert[att];
    bYR=monstre[depend].yRVert[att];
    gB1=longueur(vraiX1,vraiY1,bXR,bYR);//grosseur de la base
    gB2=longueur(bXR,bYR,vraiX2,vraiY2);//grosseur de la base    
    xR=bXR+l*cos(angle-HALF_PI);
    yR=bYR+l*sin(angle-HALF_PI);   
  }
}

class Pics extends MembresC {
  Pics(int dep, int att, float l, float corr) {
    this.depend=dep;
    this.att=att;
    this.l=l;
    this.corr=corr;
  }
  public void dessinePic() {
    float inclin=atan2(bYR-yR,bXR-xR);
    float r=(gB1+gB2)/2;
    beginShape();
    vertex(bXR+(cos(inclin+HALF_PI)*r),bYR+(sin(inclin+HALF_PI)*r));
    vertex(bXR+(cos(inclin-HALF_PI)*r),bYR+(sin(inclin-HALF_PI)*r));
    vertex(xR+(cos(inclin-HALF_PI)*(l/15)),yR+(sin(inclin-HALF_PI)*(l/15)));
    vertex(xR+(cos(inclin+HALF_PI)*(l/15)),yR+(sin(inclin+HALF_PI)*(l/15)));
    vertex(bXR+(cos(inclin+HALF_PI)*r),bYR+(sin(inclin+HALF_PI)*r));
    endShape();
    ellipse(bXR,bYR,r,r);
  }
  public void dessine() {
    defVraisD();
    dessinePic();
    defVraisG();
    dessinePic();
  }
}

class Queues extends MembresC {
  int nbBoules;
  float[] xBouD;
  float[] yBouD;
  float[] xBouG;
  float[] yBouG;
  Queues(int dep, int att, float l, float corr) {
    this.depend=dep;
    this.att=att;
    this.l=l;
    this.corr=corr;
    nbBoules=max(ceil(l*10/(sizModel/2)),1);
    xBouD=new float[nbBoules];
    yBouD=new float[nbBoules];
    xBouG=new float[nbBoules];
    yBouG=new float[nbBoules];    
    defVraisD();
    for(int i=0;i<nbBoules;i++) {
      xBouD[i]=bXR;
      xBouD[i]+=l*cos(angle+HALF_PI)*i/nbBoules;
      yBouD[i]=bYR;
      yBouD[i]+=l*sin(angle+HALF_PI)*i/nbBoules;
    }
    defVraisG();
    for(int i=0;i<nbBoules;i++) {
      xBouG[i]=bXR;
      xBouG[i]+=l*cos(angle-HALF_PI)*i/nbBoules;
      yBouG[i]=bYR;
      yBouG[i]+=l*sin(angle-HALF_PI)*i/nbBoules;
    }    
  }
  public void dessine() {
    for(int i=0;i<nbBoules;i++) {
      ellipse(xBouD[i],yBouD[i],l/nbBoules,l/nbBoules);
      ellipse(xBouG[i],yBouG[i],l/nbBoules,l/nbBoules);      
    }
  }
  public void pasBouge() {
    defVraisD();
    for(int i=0;i<nbBoules;i++) {
      xBouD[i]=bXR;
      xBouD[i]+=l*cos(angle+HALF_PI)*i/nbBoules;
      yBouD[i]=bYR;
      yBouD[i]+=l*sin(angle+HALF_PI)*i/nbBoules;
    }
    defVraisG();
    for(int i=0;i<nbBoules;i++) {
      xBouG[i]=bXR;
      xBouG[i]+=l*cos(angle-HALF_PI)*i/nbBoules;
      yBouG[i]=bYR;
      yBouG[i]+=l*sin(angle-HALF_PI)*i/nbBoules;
    }    
  }  
  public void agit() {
    defVraisD();
    xBouD[0]=bXR;
    yBouD[0]=bYR;
    for(int i=1;i<nbBoules;i++) {
      float aTmp=atan2(yBouD[i]-yBouD[i-1],xBouD[i]-xBouD[i-1]);
      xBouD[i]=xBouD[i-1]+cos(aTmp)*l/nbBoules;
      yBouD[i]=yBouD[i-1]+sin(aTmp)*l/nbBoules;
    }
    defVraisG();    
    xBouG[0]=bXR;
    yBouG[0]=bYR;
    for(int i=1;i<nbBoules;i++) {
      float aTmp=atan2(yBouG[i]-yBouG[i-1],xBouG[i]-xBouG[i-1]);
      xBouG[i]=xBouG[i-1]+cos(aTmp)*l/nbBoules;
      yBouG[i]=yBouG[i-1]+sin(aTmp)*l/nbBoules;
    }    
  }
}

class Ailes extends MembresC {
  Ailes(int dep, int att, float l, float corr) {
    this.depend=dep;
    this.att=att;
    this.l=l;
    this.corr=corr;
  }
  public void dessinePic() {
    beginShape();
    vertex(vraiX1,vraiY1);
    vertex(vraiX2,vraiY2);
    vertex(xR,yR);
    vertex(vraiX1,vraiY1);
    endShape();
    ellipse((vraiX1+bXR)/2,(vraiY1+bYR)/2,gB1,gB1);
    ellipse((vraiX2+bXR)/2,(vraiY2+bYR)/2,gB2,gB2);    
  }
  public void dessine() {
    defVraisD();
    dessinePic();
    defVraisG();
    dessinePic();
  }
}

class YeuxC extends MembresC {
  float regAD;
  float regAG;  
  YeuxC(int dep, int att, float l, float corr) {
    this.depend=dep;
    this.att=att;
    this.l=l;
    this.corr=corr;
  }
  public void agit() {
    defVraisD();    
    regAD=atan2(monstre[depend].regardeY-yR,monstre[depend].regardeX-xR);
    defVraisG();    
    regAG=atan2(monstre[depend].regardeY-yR,monstre[depend].regardeX-xR);    
  }
  public void dessinePic() {
    ellipse(xR,yR,l/5+6,l/5+6);
    beginShape();
    vertex(vraiX1,vraiY1);
    vertex(vraiX2,vraiY2);
    vertex(xR,yR);
    vertex(vraiX1,vraiY1);
    endShape();
    ellipse((vraiX1+bXR)/2,(vraiY1+bYR)/2,gB1,gB1);
    ellipse((vraiX2+bXR)/2,(vraiY2+bYR)/2,gB2,gB2);    
  }
  public void dessine() {
    defVraisD();
    dessinePic();
    defVraisG();
    dessinePic();
  }
  public void dessinePupille() {
    defVraisD();
    ellipse(xR+cos(regAD)*l/20,yR+sin(regAD)*l/20,l/7+3,l/7+3);
    defVraisG();
    ellipse(xR+cos(regAG)*l/20,yR+sin(regAG)*l/20,l/7+3,l/7+3);
  }
}

class MembresA {
  int depend;//monstre dont il depend
  int att;//bourse \u00e0 laquelle il est rattach\u00e9
  float l;//longueur
  float corr;

  float vraiX1;
  float vraiY1;
  float vraiX2;
  float vraiY2;
  float angle;
  float bXR;
  float bYR;
  float gB1;//grosseur de la base
  float gB2;//grosseur de la base  

  public void defVrais() {
    vraiX1=monstre[depend].xRBour[(att-1+nbBourses)%nbBourses];
    vraiY1=monstre[depend].yRBour[(att-1+nbBourses)%nbBourses];
    vraiX2=monstre[depend].xRBour[(att+1)%nbBourses];
    vraiY2=monstre[depend].yRBour[(att+1)%nbBourses];
    angle=atan2(vraiY2-vraiY1,vraiX2-vraiX1)+corr;
    bXR=monstre[depend].xRBour[att];
    bYR=monstre[depend].yRBour[att];
    gB1=longueur(vraiX1,vraiY1,bXR,bYR);//grosseur de la base
    gB2=longueur(bXR,bYR,vraiX2,vraiY2);//grosseur de la base    
  }
}

class Cils extends MembresA {
  Cils(int dep, int att, float l, float corr) {
    this.depend=dep;
    this.att=att;
    this.l=l;
    this.corr=corr;  
  }
  public void dessine() {
    defVrais();
    beginShape();
    vertex(vraiX1,vraiY1);
    vertex(vraiX2,vraiY2);
    vertex(bXR+l*cos(angle-HALF_PI),bYR+l*sin(angle-HALF_PI));
    vertex(vraiX1,vraiY1);
    endShape();
    ellipse((vraiX1+bXR)/2,(vraiY1+bYR)/2,gB1,gB1);
    ellipse((vraiX2+bXR)/2,(vraiY2+bYR)/2,gB2,gB2);
  }
}

class Tentacules extends MembresA {
  int nbBoules;
  float[] xBou;
  float[] yBou;
  Tentacules(int dep, int att, float l, float corr) {
    this.depend=dep;
    this.att=att;
    this.l=l;
    this.corr=corr;
    nbBoules=max(ceil(l*10/(sizModel/2)),1);
    xBou=new float[nbBoules];
    yBou=new float[nbBoules];
    defVrais();
    for(int i=0;i<nbBoules;i++) {
      xBou[i]=bXR;
      xBou[i]+=l*cos(angle-HALF_PI)*i/nbBoules;
      yBou[i]=bYR;
      yBou[i]+=l*sin(angle-HALF_PI)*i/nbBoules;
    }
  }
  public void dessine() {
    defVrais();
    for(int i=0;i<nbBoules;i++) {
      ellipse(xBou[i],yBou[i],l/nbBoules,l/nbBoules);
    }
  }
  public void pasBouge() {
    defVrais();
    for(int i=0;i<nbBoules;i++) {
      xBou[i]=bXR;
      xBou[i]+=l*cos(angle-HALF_PI)*i/nbBoules;
      yBou[i]=bYR;
      yBou[i]+=l*sin(angle-HALF_PI)*i/nbBoules;
    }
  }  
  public void agit() {
    xBou[0]=bXR;
    yBou[0]=bYR;
    for(int i=1;i<nbBoules;i++) {
      float prevyBou=yBou[i];
      yBou[i]+=(sin(monstre[depend].prevtPosY)-sin(monstre[depend].tPosY))*100;
      yBou[i]+=3;
      xBou[i]*=max((prevyBou-yBou[i])/10,1);
      float aTmp=atan2(yBou[i]-yBou[i-1],xBou[i]-xBou[i-1]);
      xBou[i]=xBou[i-1]+cos(aTmp)*l/nbBoules;
      yBou[i]=yBou[i-1]+sin(aTmp)*l/nbBoules;
    }    
  }  
}

class Bras extends MembresA {
  int nbDiv;
  float t=0;
  Bras(int dep, int att, float l, float corr) {
    this.depend=dep;
    this.att=att;
    this.l=l;
    this.corr=corr;  
    this.nbDiv=floor(l*50/sizModel)+1;
  }
  public void pasBouge() {
  }  
  public void agit() {
    t+=0.1;
    t=t%TWO_PI;
  }  
  public void dessine() {
    defVrais();
    beginShape();
    vertex(vraiX1,vraiY1);
    vertex(vraiX2,vraiY2);
    for (int i=0;i<nbDiv;i++) {
      float coeff=((float)i)/((float)nbDiv);
      float coeff2=1-abs(coeff-0.5);
      float x=(bXR+l*cos(angle-HALF_PI))*coeff;
      x+=vraiX2*(1-coeff);
      x+=cos(t+(float)i*TWO_PI/(float)nbDiv)*l/nbDiv*coeff2;      //anim
      float y=(bYR+l*sin(angle-HALF_PI))*coeff;
      y+=vraiY2*(1-coeff);
      y+=sin(t+(float)i*TWO_PI/(float)nbDiv)*l/nbDiv*coeff2;      //anim
      vertex(x,y);
    }
    vertex(bXR+l*cos(angle-HALF_PI),bYR+l*sin(angle-HALF_PI));
    for (int i=nbDiv-1;i>=0;i--) {
      float coeff=((float)i)/((float)nbDiv);
      float coeff2=1-abs(coeff-0.5);
      float x=(bXR+l*cos(angle-HALF_PI))*coeff;
      x+=vraiX1*(1-coeff);
      x+=cos(t+(float)i*TWO_PI/(float)nbDiv)*l/nbDiv*coeff2;            //anim
      float y=(bYR+l*sin(angle-HALF_PI))*coeff;
      y+=vraiY1*(1-coeff);
      y+=sin(t+(float)i*TWO_PI/(float)nbDiv)*l/nbDiv*coeff2;            //anim
      vertex(x,y);
    }    
    vertex(vraiX1,vraiY1);
    endShape();
    ellipse((vraiX1+bXR)/2,(vraiY1+bYR)/2,gB1,gB1);
    ellipse((vraiX2+bXR)/2,(vraiY2+bYR)/2,gB2,gB2);
  }
}

class YeuxA extends MembresA {
  float xGlobe;
  float yGlobe;
  float regA;
  YeuxA(int dep, int att, float l, float corr) {
    this.depend=dep;
    this.att=att;
    this.l=l;
    this.corr=corr;  
  }
  public void agit() {
    regA=atan2(monstre[depend].regardeY-yGlobe,monstre[depend].regardeX-xGlobe);
  }  
  public void dessine() {
    defVrais();
    xGlobe=bXR+(l/2)*cos(angle-HALF_PI);
    yGlobe=bYR+(l/2)*sin(angle-HALF_PI);
    triangle(0,0,xGlobe+(l/2)*cos(angle),yGlobe+(l/2)*sin(angle),xGlobe+(l/2)*cos(angle+PI),yGlobe+(l/2)*sin(angle+PI));
    float r=max(l,sizModel/10);
    ellipse(xGlobe,yGlobe,r,r);
  }
  public void dessinePupille() {
    float r=max(l,sizModel/10);    
    ellipse(bXR+l/2*cos(angle-HALF_PI)+cos(regA)*l/6,bYR+l/2*sin(angle-HALF_PI)+sin(regA)*l/6,r*1/3,r*1/3);
  }
}
